/*
 * Decompiled with CFR 0.152.
 */
package de._3DTetris;

import de._3DTetris.Punkt3D;
import de._3DTetris.graphic.IColor;
import de._3DTetris.util.ComputationUtility;
import de._3DTetris.util.ISystemInfo;
import de._3DTetris.util._3DTetrisClassFactory;

public class Beleuchtungsmodell {
    private Punkt3D m_LQ;
    private boolean m_IsRenderable;

    public Beleuchtungsmodell() {
        this.init(0.0, 0.2, 1.0);
    }

    public IColor getOFFarbe(IColor ofFarbe, Punkt3D flNormale) {
        int blue;
        int green;
        int red;
        double winkel = ComputationUtility.computeScalarProductOfNormalisedVector(this.m_LQ, flNormale);
        if (winkel > 0.0) {
            red = (int)((double)ofFarbe.getRed() * winkel);
            green = (int)((double)ofFarbe.getGreen() * winkel);
            blue = (int)((double)ofFarbe.getBlue() * winkel);
        } else {
            blue = 0;
            green = 0;
            red = 0;
        }
        IColor farbe = _3DTetrisClassFactory.instanceColorClass();
        farbe.setRed(red);
        farbe.setGreen(green);
        farbe.setBlue(blue);
        return farbe;
    }

    public boolean isRenderable() {
        return this.m_IsRenderable;
    }

    private void init(double xLQ, double yLQ, double zLQ) {
        this.m_LQ = new Punkt3D(xLQ, yLQ, zLQ);
        this.m_LQ.normalisieren();
        ISystemInfo sysInfo = _3DTetrisClassFactory.instanceSystemInfoClass();
        this.m_IsRenderable = sysInfo.isRenderable();
    }
}

