/*
 * Decompiled with CFR 0.152.
 */
package de._3DTetris;

import de._3DTetris.GitterElement;
import de._3DTetris.Punkt3D;
import de._3DTetris.Vergleich;
import de._3DTetris.graphic.IColor;
import de._3DTetris.util._3DTetrisClassFactory;

public class GPunkt
implements GitterElement,
Vergleich {
    protected int m_BIndex;
    protected int m_LIndex;
    protected int m_HIndex;
    private int m_OldBIndex;
    private int m_OldLIndex;
    private int m_OldHIndex;

    public GPunkt() {
    }

    public GPunkt(int bIndex, int lIndex, int hIndex) {
        this.setIndex(bIndex, lIndex, hIndex);
        this.speichern();
    }

    public void setIndex(int bIndex, int lIndex, int hIndex) {
        this.m_BIndex = bIndex;
        this.m_LIndex = lIndex;
        this.m_HIndex = hIndex;
    }

    public int ermBIndex() {
        return this.m_BIndex;
    }

    public int ermLIndex() {
        return this.m_LIndex;
    }

    public int ermHIndex() {
        return this.m_HIndex;
    }

    public GPunkt copyPunkt() {
        GPunkt p = new GPunkt();
        p.m_BIndex = this.m_BIndex;
        p.m_HIndex = this.m_HIndex;
        p.m_LIndex = this.m_LIndex;
        p.m_OldBIndex = this.m_OldBIndex;
        p.m_OldHIndex = this.m_OldHIndex;
        p.m_OldLIndex = this.m_OldLIndex;
        return p;
    }

    public String toString() {
        return "GPunkt@" + this.hashCode() + "(x = " + this.m_BIndex + " z = " + this.m_LIndex + " y = " + this.m_HIndex + ")";
    }

    public short vergleichen(Vergleich element) {
        GPunkt p2 = (GPunkt)element;
        if (this.ermHIndex() < p2.ermHIndex()) {
            return 2;
        }
        if (this.ermHIndex() > p2.ermHIndex()) {
            return 1;
        }
        if (this.ermLIndex() < p2.ermLIndex()) {
            return 2;
        }
        if (this.ermLIndex() > p2.ermLIndex()) {
            return 1;
        }
        if (this.ermBIndex() < p2.ermBIndex()) {
            return 2;
        }
        if (this.ermBIndex() > p2.ermBIndex()) {
            return 1;
        }
        return 0;
    }

    public void ebenen(int anzahl) {
        this.speichern();
        this.m_HIndex += anzahl;
    }

    public void zeilen(int anzahl) {
        this.speichern();
        this.m_LIndex += anzahl;
    }

    public void spalten(int anzahl) {
        this.speichern();
        this.m_BIndex += anzahl;
    }

    public void zurueck() {
        this.m_BIndex = this.m_OldBIndex;
        this.m_LIndex = this.m_OldLIndex;
        this.m_HIndex = this.m_OldHIndex;
    }

    private void speichern() {
        this.m_OldBIndex = this.m_BIndex;
        this.m_OldLIndex = this.m_LIndex;
        this.m_OldHIndex = this.m_HIndex;
    }

    public void rotZ(Punkt3D mPunkt) {
        this.speichern();
        this.m_BIndex = (int)(-((double)this.m_OldHIndex - mPunkt.ermY()) + mPunkt.ermX());
        this.m_HIndex = (short)((double)this.m_OldBIndex - mPunkt.ermX() + mPunkt.ermY());
    }

    public void rotY(Punkt3D mPunkt) {
        this.speichern();
        this.m_LIndex = (int)(-((double)this.m_OldBIndex - mPunkt.ermX()) + mPunkt.ermZ());
        this.m_BIndex = (int)((double)this.m_OldLIndex - mPunkt.ermZ() + mPunkt.ermX());
    }

    public void rotX(Punkt3D mPunkt) {
        this.speichern();
        this.m_HIndex = (short)(-((double)this.m_OldLIndex - mPunkt.ermZ()) + mPunkt.ermY());
        this.m_LIndex = (int)((double)this.m_OldHIndex - mPunkt.ermY() + mPunkt.ermZ());
    }

    public GPunkt[] ermPunkte() {
        GPunkt[] pkte = new GPunkt[]{this};
        return pkte;
    }

    public IColor ermFarbe() {
        IColor gray = _3DTetrisClassFactory.instanceColorClass();
        gray.setRed(0);
        gray.setGreen(0);
        gray.setBlue(0);
        return gray;
    }

    public Vergleich[] createArray(int length) {
        return new GPunkt[length];
    }
}

