/*
 * Decompiled with CFR 0.152.
 */
package de._3DTetris;

import de._3DTetris.util.ComputationUtility;

public class Punkt3D {
    private double m_X;
    private double m_Y;
    private double m_Z;

    public boolean equals(Object obj) {
        return this.m_X == ((Punkt3D)obj).m_X && this.m_Y == ((Punkt3D)obj).m_Y && this.m_Z == ((Punkt3D)obj).m_Z;
    }

    public Punkt3D() {
        this.m_X = 0.0;
        this.m_Y = 0.0;
        this.m_Z = 0.0;
    }

    public Punkt3D(double x, double y, double z) {
        this.setPkt(x, y, z);
    }

    public double ermX() {
        return this.m_X;
    }

    public double ermY() {
        return this.m_Y;
    }

    public double ermZ() {
        return this.m_Z;
    }

    public void setPkt(double x, double y, double z) {
        this.m_X = x;
        this.m_Y = y;
        this.m_Z = z;
    }

    public String toString() {
        return "Punkt3D@" + this.hashCode() + " {X = " + this.m_X + " Y = " + this.m_Y + " Z = " + this.m_Z + "}";
    }

    public static Punkt3D minus(Punkt3D p1, Punkt3D p2) {
        Punkt3D erg = new Punkt3D();
        erg.m_X = p1.m_X - p2.m_X;
        erg.m_Y = p1.m_Y - p2.m_Y;
        erg.m_Z = p1.m_Z - p2.m_Z;
        return erg;
    }

    public static Punkt3D plus(Punkt3D p1, Punkt3D p2) {
        Punkt3D erg = new Punkt3D();
        erg.m_X = p1.m_X + p2.m_X;
        erg.m_Y = p1.m_Y + p2.m_Y;
        erg.m_Z = p1.m_Z + p2.m_Z;
        return erg;
    }

    public void plus(Punkt3D p2) {
        this.m_X += p2.m_X;
        this.m_Y += p2.m_Y;
        this.m_Z += p2.m_Z;
    }

    public void div(double wert) {
        this.m_X /= wert;
        this.m_Y /= wert;
        this.m_Z /= wert;
    }

    public void xRot(double winkel) {
        double kosinus = Math.cos(winkel);
        double sinus = Math.sin(winkel);
        double yBuf = this.m_Y * kosinus - this.m_Z * sinus;
        double zBuf = this.m_Y * sinus + this.m_Z * kosinus;
        this.m_Y = yBuf;
        this.m_Z = zBuf;
    }

    public void yRot(double winkel) {
        double kosinus = Math.cos(winkel);
        double sinus = Math.sin(winkel);
        double xBuf = this.m_X * kosinus + this.m_Z * sinus;
        double zBuf = -this.m_X * sinus + this.m_Z * kosinus;
        this.m_X = xBuf;
        this.m_Z = zBuf;
    }

    public void zRot(double winkel) {
        double kosinus = Math.cos(winkel);
        double sinus = Math.sin(winkel);
        double xBuf = this.m_X * kosinus - this.m_Y * sinus;
        double yBuf = this.m_X * sinus + this.m_Y * kosinus;
        this.m_X = xBuf;
        this.m_Y = yBuf;
    }

    public void normalisieren() {
        double magnitude = ComputationUtility.computeMagnitudeOfVector(this.m_X, this.m_Y, this.m_Z);
        this.m_X /= magnitude;
        this.m_Y /= magnitude;
        this.m_Z /= magnitude;
    }

    public void move(double d) {
        this.m_X += d;
        this.m_Y += d;
        this.m_Z += d;
    }
}

