/*
 * Decompiled with CFR 0.152.
 */
package de._3DTetris;

import de._3DTetris.TetrisSzeneCanvas;
import de._3DTetris.game.IGameRotationListener;
import de._3DTetris.graphic.IGameCanvas;
import de._3DTetris.graphic.ITetrisControlerPanel;
import de._3DTetris.util.ISystemInfo;
import de._3DTetris.util._3DTetrisClassFactory;

public class TetrisControler
implements IGameRotationListener {
    private final TetrisSzeneCanvas _TetrisSzeneCanvas;
    private final IGameCanvas _GameCanvas;
    private final ITetrisControlerPanel _ControlPanel;
    private final Timer _TimerThread;
    private boolean _CanStartNew = true;
    private int _BlockId = -1;
    private int _NextBlockId = -1;
    private int _PlanCount;
    private boolean _GamePause = true;
    private long _SleepTime = 2000L;

    public TetrisControler(ITetrisControlerPanel controlPanel, IGameCanvas gameCanvas) {
        this._ControlPanel = controlPanel;
        this._GameCanvas = gameCanvas;
        this._TetrisSzeneCanvas = new TetrisSzeneCanvas(this._GameCanvas);
        this._GameCanvas.addGameRotationListener(this);
        this._TimerThread = new Timer();
        this._TimerThread.start();
        this._ControlPanel.setTetrisControler(this);
    }

    public long timerwert() {
        this._SleepTime = (long)Math.ceil((double)this._SleepTime * 0.9);
        return this._SleepTime;
    }

    public int next() {
        return _3DTetrisClassFactory.instanceSystemInfoClass().getNextRandomBlock();
    }

    public void gamePause() {
        this._TimerThread.stoppen();
        this._GamePause = true;
        this._TetrisSzeneCanvas.gamePause();
    }

    public boolean isGamePause() {
        return this._GamePause;
    }

    public void gameRotation(double alpha, double beta, double gamma) {
        this._TetrisSzeneCanvas.gesamtRot(alpha, beta, gamma);
    }

    public boolean beginPlay() {
        if (this._CanStartNew) {
            ISystemInfo sysInfo = _3DTetrisClassFactory.instanceSystemInfoClass();
            this._TetrisSzeneCanvas.beginNewPlay(sysInfo.getGridPlanCount(), sysInfo.getGridColumnCount(), sysInfo.getGridRowCount());
            this._CanStartNew = false;
            this._PlanCount = 0;
            this._TimerThread.setSleepTime(2000L);
            this._BlockId = this.next();
        }
        this._GamePause = false;
        this._TimerThread.starten();
        return this._CanStartNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveBlockDown(boolean allPlanes) {
        if (this._GamePause) {
            return;
        }
        TetrisSzeneCanvas tetrisSzeneCanvas = this._TetrisSzeneCanvas;
        synchronized (tetrisSzeneCanvas) {
            int removedPlanes = this._TetrisSzeneCanvas.moveBlockDown(allPlanes);
            if (removedPlanes > 0) {
                this._PlanCount += removedPlanes;
                this._NextBlockId = this.next();
                if (this._PlanCount >= 5) {
                    this._ControlPanel.startNextLevel();
                    this._TimerThread.setSleepTime(this.timerwert());
                    this._PlanCount = 0;
                }
                if (!this._TetrisSzeneCanvas.setNextBlock(this._BlockId)) {
                    this._CanStartNew = true;
                    this._ControlPanel.gameOver();
                    this.gamePause();
                    this._TetrisSzeneCanvas.gameOver();
                }
                this._BlockId = this._NextBlockId;
            } else if (removedPlanes == -1) {
                this._NextBlockId = this.next();
                if (!this._TetrisSzeneCanvas.setNextBlock(this._BlockId)) {
                    this._CanStartNew = true;
                    this._ControlPanel.gameOver();
                    this.gamePause();
                    this._TetrisSzeneCanvas.gameOver();
                    return;
                }
                this._BlockId = this._NextBlockId;
            }
            this._ControlPanel.setRemovedPlanCount(removedPlanes);
        }
    }

    public boolean isCanStartNew() {
        return this._CanStartNew;
    }

    public int getPlanCount() {
        return this._PlanCount;
    }

    public int getNextBlockId() {
        return this._NextBlockId;
    }

    public void moveTetrisBlock(int direction) {
        this._TetrisSzeneCanvas.moveTetrisBlock(direction);
    }

    public void reset() {
        this._TetrisSzeneCanvas.reset();
    }

    public void rotateTetrisBlock(int achse) {
        this._TetrisSzeneCanvas.rotateTetrisBlock(achse);
    }

    public IGameCanvas getGameCanvas() {
        return this._GameCanvas;
    }

    class Timer
    extends Thread {
        private long _SleepTime = 0L;
        private final Object _WaitObject = new Object();
        private boolean _CanRun = false;

        Timer() {
        }

        private void setSleepTime(long sleepTime) {
            this._SleepTime = sleepTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stoppen() {
            Object object = this._WaitObject;
            synchronized (object) {
                this._CanRun = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void starten() {
            Object object = this._WaitObject;
            synchronized (object) {
                this._CanRun = true;
                this._WaitObject.notify();
                TetrisControler.this._TetrisSzeneCanvas.gameStart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    Object object = this._WaitObject;
                    synchronized (object) {
                        if (!this._CanRun) {
                            this._WaitObject.wait();
                        }
                    }
                    TetrisControler.this.moveBlockDown(false);
                    try {
                        Timer.sleep(this._SleepTime);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (Exception e) {
                System.out.println(e);
                return;
            }
        }
    }
}

