/*
 * Decompiled with CFR 0.152.
 */
package de._3DTetris;

import de._3DTetris.GPunkt;
import de._3DTetris.GQuadrat;
import de._3DTetris.GitterElement;
import de._3DTetris.Punkt3D;
import de._3DTetris.Vergleich;
import de._3DTetris.graphic.IColor;

public class GWuerfel
implements GitterElement,
Vergleich {
    private GPunkt[] m_Punkte;
    private IColor m_Farbe;
    private GPunkt m_MPunkt;
    GQuadrat[] m_Quadrate;

    public GWuerfel() {
    }

    public GWuerfel(int bIndex, int lIndex, int hIndex, IColor farbe) {
        this.m_MPunkt = new GPunkt(bIndex, lIndex, hIndex);
        this.m_Farbe = farbe;
        this.erzWuerfel();
    }

    public GQuadrat[] ermFlaechen() {
        return this.m_Quadrate;
    }

    private void erzWuerfel() {
        this.m_Punkte = new GPunkt[8];
        this.m_Punkte[0] = new GPunkt(this.m_MPunkt.ermBIndex(), this.m_MPunkt.ermLIndex(), this.m_MPunkt.ermHIndex());
        this.m_Punkte[1] = new GPunkt(this.m_MPunkt.ermBIndex() + 1, this.m_MPunkt.ermLIndex(), this.m_MPunkt.ermHIndex());
        this.m_Punkte[2] = new GPunkt(this.m_MPunkt.ermBIndex(), this.m_MPunkt.ermLIndex() + 1, this.m_MPunkt.ermHIndex());
        this.m_Punkte[3] = new GPunkt(this.m_MPunkt.ermBIndex() + 1, this.m_MPunkt.ermLIndex() + 1, this.m_MPunkt.ermHIndex());
        this.m_Punkte[4] = new GPunkt(this.m_MPunkt.ermBIndex(), this.m_MPunkt.ermLIndex(), this.m_MPunkt.ermHIndex() + 1);
        this.m_Punkte[5] = new GPunkt(this.m_MPunkt.ermBIndex() + 1, this.m_MPunkt.ermLIndex(), this.m_MPunkt.ermHIndex() + 1);
        this.m_Punkte[6] = new GPunkt(this.m_MPunkt.ermBIndex(), this.m_MPunkt.ermLIndex() + 1, this.m_MPunkt.ermHIndex() + 1);
        this.m_Punkte[7] = new GPunkt(this.m_MPunkt.ermBIndex() + 1, this.m_MPunkt.ermLIndex() + 1, this.m_MPunkt.ermHIndex() + 1);
        this.erzeugeFlaechen();
    }

    private void erzeugeFlaechen() {
        this.m_Quadrate = new GQuadrat[6];
        this.m_Quadrate[0] = new GQuadrat(this.m_Punkte[0], this.m_Punkte[1], this.m_Punkte[2], this.m_Punkte[3], this.m_Farbe, true);
        this.m_Quadrate[1] = new GQuadrat(this.m_Punkte[0], this.m_Punkte[1], this.m_Punkte[4], this.m_Punkte[5], this.m_Farbe, false);
        this.m_Quadrate[2] = new GQuadrat(this.m_Punkte[0], this.m_Punkte[2], this.m_Punkte[4], this.m_Punkte[6], this.m_Farbe, true);
        this.m_Quadrate[3] = new GQuadrat(this.m_Punkte[1], this.m_Punkte[3], this.m_Punkte[5], this.m_Punkte[7], this.m_Farbe, false);
        this.m_Quadrate[4] = new GQuadrat(this.m_Punkte[2], this.m_Punkte[3], this.m_Punkte[6], this.m_Punkte[7], this.m_Farbe, true);
        this.m_Quadrate[5] = new GQuadrat(this.m_Punkte[4], this.m_Punkte[5], this.m_Punkte[6], this.m_Punkte[7], this.m_Farbe, false);
    }

    public short vergleichen(Vergleich element) {
        GWuerfel p2 = (GWuerfel)element;
        if (this.m_MPunkt.ermHIndex() < p2.ermHIndex()) {
            return 2;
        }
        if (this.m_MPunkt.ermHIndex() > p2.ermHIndex()) {
            return 1;
        }
        if (this.m_MPunkt.ermLIndex() < p2.ermLIndex()) {
            return 2;
        }
        if (this.m_MPunkt.ermLIndex() > p2.ermLIndex()) {
            return 1;
        }
        if (this.m_MPunkt.ermBIndex() < p2.ermBIndex()) {
            return 2;
        }
        if (this.m_MPunkt.ermBIndex() > p2.ermBIndex()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "GWuerfel(" + this.m_MPunkt.ermHIndex() + ", " + this.m_MPunkt.ermLIndex() + ", " + this.m_MPunkt.ermBIndex() + ")";
    }

    public void ebenen(int anzahl) {
        this.m_MPunkt.ebenen(anzahl);
        for (int i = 0; i < this.m_Punkte.length; ++i) {
            this.m_Punkte[i].ebenen(anzahl);
        }
    }

    public void zeilen(int anzahl) {
        this.m_MPunkt.zeilen(anzahl);
        for (int i = 0; i < this.m_Punkte.length; ++i) {
            this.m_Punkte[i].zeilen(anzahl);
        }
    }

    public void spalten(int anzahl) {
        this.m_MPunkt.spalten(anzahl);
        for (int i = 0; i < this.m_Punkte.length; ++i) {
            this.m_Punkte[i].spalten(anzahl);
        }
    }

    public void rotZ(Punkt3D mPunkt) {
        this.m_MPunkt.rotZ(mPunkt);
        Punkt3D mIndex = new Punkt3D(mPunkt.ermX() + 0.5, mPunkt.ermY() + 0.5, mPunkt.ermZ() + 0.5);
        for (int i = 0; i < this.m_Punkte.length; ++i) {
            this.m_Punkte[i].rotZ(mIndex);
        }
    }

    public void rotY(Punkt3D mPunkt) {
        this.m_MPunkt.rotY(mPunkt);
        Punkt3D mIndex = new Punkt3D(mPunkt.ermX() + 0.5, mPunkt.ermY() + 0.5, mPunkt.ermZ() + 0.5);
        for (int i = 0; i < this.m_Punkte.length; ++i) {
            this.m_Punkte[i].rotY(mIndex);
        }
    }

    public void rotX(Punkt3D mPunkt) {
        this.m_MPunkt.rotX(mPunkt);
        Punkt3D mIndex = new Punkt3D(mPunkt.ermX() + 0.5, mPunkt.ermY() + 0.5, mPunkt.ermZ() + 0.5);
        for (int i = 0; i < this.m_Punkte.length; ++i) {
            this.m_Punkte[i].rotX(mIndex);
        }
    }

    public int ermBIndex() {
        return this.m_MPunkt.ermBIndex();
    }

    public int ermLIndex() {
        return this.m_MPunkt.ermLIndex();
    }

    public int ermHIndex() {
        return this.m_MPunkt.ermHIndex();
    }

    public IColor ermFarbe() {
        return this.m_Farbe;
    }

    public void zurueck() {
        this.m_MPunkt.zurueck();
        for (int i = 0; i < this.m_Punkte.length; ++i) {
            this.m_Punkte[i].zurueck();
        }
    }

    public GWuerfel copyWuerfel() {
        GWuerfel w = new GWuerfel();
        w.m_Punkte = new GPunkt[this.m_Punkte.length];
        for (int i = 0; i < this.m_Punkte.length; ++i) {
            w.m_Punkte[i] = this.m_Punkte[i].copyPunkt();
        }
        w.m_Farbe = this.m_Farbe;
        w.m_MPunkt = this.m_MPunkt.copyPunkt();
        w.erzeugeFlaechen();
        return w;
    }

    public GPunkt[] ermPunkte() {
        return this.m_Punkte;
    }

    public Vergleich[] createArray(int length) {
        return new GWuerfel[length];
    }
}

