/*
 * Decompiled with CFR 0.152.
 */
package de._3DTetris;

import de._3DTetris.Bildpunkt;
import de._3DTetris.GPunkt;
import de._3DTetris.Punkt3D;
import de._3DTetris.Zentralprojektion;
import de._3DTetris.util.ComputationUtility;

public final class Gitter3D {
    private int m_LAnzahl = 0;
    private int m_BAnzahl = 0;
    private int m_HAnzahl = 0;
    private Punkt3D[][][] m_P3D = null;
    private Bildpunkt[][][] m_PBild = null;
    private Zentralprojektion m_Zentral = null;
    private int m_Breite = 0;
    private int m_Hoehe = 0;
    private double _CubeEdge = 0.0;

    public Gitter3D(int bIndex, int lIndex, int hIndex, int breite, int hoehe) {
        this.m_LAnzahl = lIndex;
        this.m_BAnzahl = bIndex;
        this.m_HAnzahl = hIndex;
        this._CubeEdge = ComputationUtility.computeCubeEdge(this.m_LAnzahl, this.m_BAnzahl, this.m_HAnzahl);
        this.setParam(breite, hoehe);
        this.erz3DGitterPunkte();
        this.erzBildpunkte();
    }

    private void erz3DGitterPunkte() {
        double hB = (double)this.m_BAnzahl / 2.0;
        double hL = (double)this.m_LAnzahl / 2.0;
        double hH = (double)this.m_HAnzahl / 2.0;
        this.m_P3D = new Punkt3D[this.m_BAnzahl + 1][][];
        for (int bIndex = 0; bIndex <= this.m_BAnzahl; ++bIndex) {
            this.m_P3D[bIndex] = new Punkt3D[this.m_LAnzahl + 1][];
            for (int lIndex = 0; lIndex <= this.m_LAnzahl; ++lIndex) {
                this.m_P3D[bIndex][lIndex] = new Punkt3D[this.m_HAnzahl + 1];
                for (int hIndex = 0; hIndex <= this.m_HAnzahl; ++hIndex) {
                    this.m_P3D[bIndex][lIndex][hIndex] = new Punkt3D(((double)bIndex - hB) * this._CubeEdge, ((double)hIndex - hH) * this._CubeEdge, ((double)lIndex - hL) * this._CubeEdge);
                }
            }
        }
    }

    public void erzBildpunkte() {
        int laenge = this.m_Breite < this.m_Hoehe ? this.m_Breite : this.m_Hoehe;
        this.m_Zentral = new Zentralprojektion(0.0, 1000.0);
        this.m_PBild = new Bildpunkt[this.m_BAnzahl + 1][][];
        for (int bIndex = 0; bIndex <= this.m_BAnzahl; ++bIndex) {
            this.m_PBild[bIndex] = new Bildpunkt[this.m_LAnzahl + 1][];
            for (int lIndex = 0; lIndex <= this.m_LAnzahl; ++lIndex) {
                this.m_PBild[bIndex][lIndex] = new Bildpunkt[this.m_HAnzahl + 1];
                for (int hIndex = 0; hIndex <= this.m_HAnzahl; ++hIndex) {
                    this.m_PBild[bIndex][lIndex][hIndex] = this.m_Zentral.berechne(this.m_P3D[bIndex][lIndex][hIndex], (double)laenge, this.m_Breite, this.m_Hoehe);
                }
            }
        }
    }

    public void rotieren(double alpha, double beta, double gamma) {
        int laenge = this.m_Breite < this.m_Hoehe ? this.m_Breite : this.m_Hoehe;
        for (int bIndex = 0; bIndex <= this.m_BAnzahl; ++bIndex) {
            for (int lIndex = 0; lIndex <= this.m_LAnzahl; ++lIndex) {
                for (int hIndex = 0; hIndex <= this.m_HAnzahl; ++hIndex) {
                    if (alpha != 0.0) {
                        this.m_P3D[bIndex][lIndex][hIndex].xRot(alpha);
                    }
                    if (beta != 0.0) {
                        this.m_P3D[bIndex][lIndex][hIndex].yRot(beta);
                    }
                    if (gamma != 0.0) {
                        this.m_P3D[bIndex][lIndex][hIndex].zRot(gamma);
                    }
                    this.m_PBild[bIndex][lIndex][hIndex] = this.m_Zentral.berechne(this.m_P3D[bIndex][lIndex][hIndex], (double)laenge, this.m_Breite, this.m_Hoehe);
                }
            }
        }
    }

    public void rotieren(int xGrad, int yGrad, int zGrad) {
        double alpha = (double)xGrad * Math.PI / 180.0;
        double beta = (double)yGrad * Math.PI / 180.0;
        double gamma = (double)zGrad * Math.PI / 180.0;
        this.rotieren(alpha, beta, gamma);
    }

    public void setParam(int breite, int hoehe) {
        this.m_Hoehe = hoehe;
        this.m_Breite = breite;
    }

    public Bildpunkt ermPBild(GPunkt gPunkt) {
        int bI = gPunkt.ermBIndex();
        int lI = gPunkt.ermLIndex();
        int hI = gPunkt.ermHIndex();
        Bildpunkt b = null;
        try {
            b = this.m_PBild[bI][lI][hI];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println(e);
            return null;
        }
        return b;
    }

    public Punkt3D ermP3D(GPunkt gPunkt) {
        Punkt3D p3D;
        int bI = gPunkt.ermBIndex();
        int lI = gPunkt.ermLIndex();
        int hI = gPunkt.ermHIndex();
        try {
            p3D = this.m_P3D[bI][lI][hI];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println(e);
            return null;
        }
        return p3D;
    }

    public void reset() {
        this.erz3DGitterPunkte();
        this.erzBildpunkte();
        this.rotieren(0, 0, 0);
        this.rotieren(0, -50, 0);
        this.rotieren(40, 0, 0);
    }
}

